type
  TInspListBox=class(TCustomPropListBox)
  private
   FSelection          :TPropSelection;
   FEdit               :TPropInspEdit;
   FListButton         :TListButton;
   FListGlyph          :TBitmap;
   FDialogGlyph        :TBitmap;
   FButtonVisible      :Boolean;
   FInPropAccess       :Integer;
   FTrackMode          :TTrackMode;
   FModalReturn        :IActivatable;
   FMousePos           :Integer;
   FDragPos            :Integer;
   FDragDelta          :Integer;
   FSelectString       :string;
   FCancelValue        :WideString;
   FReadOnlyMsg        :string;
   FProcessChange      :Boolean;
   FStillProcessingChange:Boolean;
   FNamesSelected      :Boolean;
   FQueryButtonVisible :Boolean;
   FReadOnly           :Boolean;
   FQueryGlyph         :TBitmap;
   FQueryButton        :TSpeedButton;
   FStart              :Integer;
   FInitialized        :Boolean;
   FDirty              :Boolean;
   FInAutoUpdate       :Boolean;
   FInEditFocus        :Boolean;
   FItemsReset         :Boolean;
   FHighlightOnSelect  :Boolean;
   FPendingFormDestroyWnd:Boolean;
   FOnSelectItem       :TNotifyEvent;
   FOnEditDblClick     :TEditDblClickEvent;
   FOnHelp             :TNotifyEvent;
   FOnNCHitTest        :TMouseMoveEvent;
   FOnListButtonClick  :TNotifyEvent;
   FOnQueryButtonClick :TNotifyEvent;
   FControlsHidden     :Boolean;
   FSaveTopIndex       :Integer;
   FHintFontStyle      :TFontStyles;
   FWasFocused         :Boolean;
   FSaveSelStart       :Integer;
   FSaveSelLength      :Integer;
   FOnSelectionKeyDown :TKeyEvent;
   FOnSelectionKeyPress:TKeyPressEvent;
   FOnEditKeyPress     :TKeyPressEvent;
   FGetHintStrEvent    :TGetHintStrEvent;
   function GetListItem(Index: Integer): Variant;
  public
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure Reset;
   procedure DoExit;
   procedure GetPropValue;
   function SetPropValue(CheckModified: Boolean; HandleException: Boolean): Boolean;
   procedure ShowControls;
   procedure SelectItem(Index: Integer);
   procedure BlankItems;
   function ItemIsVisible(I: Integer): Boolean;
   function ItemVisibleCount: Integer;
   procedure InvalidateItem(Index: Integer);
   procedure InvalidateSelection;
   function IsQueryButtonDown: Boolean;
   procedure ListButtonCloseUp(Accept: Boolean);
   procedure ValidateExpandedItemPaths(AStrings: TStrings);
   procedure ReexpandItemPaths(AStrings: TStrings; ExpandNewRootLevels: Boolean);
   function GetItemPath(Index: Integer): string;
   function GetCurItemPath: string;
   procedure EditFocus;
   function IsListButtonDropped: Boolean;
   procedure AfterReexpandItem(Index: Integer);
   property Start: Integer;
   property Initialized: Boolean;
   property Dirty: Boolean;
   property Edit: TPropInspEdit;
   property InPropAccess: Boolean;
   property ModalReturn: IActivatable;
   property HighlightOnSelect: Boolean;
   property PendingFormDestroyWnd: Boolean;
  published
   property Align: TAlign;
   property Anchors: TAnchors;
   property Count: Integer;
   property Ctl3D: Boolean;
   property CurIndex: Integer;
   property Enabled: Boolean;
   property Font: TFont;
   property ItemHeight: Integer;
   property Middle: Integer;
   property ParentColor: Boolean;
   property ParentCtl3D: Boolean;
   property ParentFont: Boolean;
   property PopupMenu: TPopupMenu;
   property ShowGridLines: Boolean;
   property BackgroundColor: TColor;
   property PropNameColor: TColor;
   property PropValueColor: TColor;
   property EditBackgroundColor: TColor;
   property EditValueColor: TColor;
   property CategoryColor: TColor;
   property GutterColor: TColor;
   property GutterEdgeColor: TColor;
   property ReferenceColor: TColor;
   property SubPropColor: TColor;
   property ReadOnlyColor: TColor;
   property NonDefaultColor: TColor;
   property NonDefaultFontStyle: TFontStyles;
   property HighlightColor: TColor;
   property HighlightFontColor: TColor;
   property ShowGutter: Boolean;
   property ReadOnly: Boolean;
   property ReadOnlyMsg: string;
   property ShowHint: Boolean;
   property TabOrder: TTabOrder;
   property TabStop: Boolean;
   property Visible: Boolean;
   property OnAfterReset: TNotifyEvent;
   property OnAllowExpansion: TAllowExpansionEvent;
   property OnBeforeReset: TNotifyEvent;
   property OnClick: TNotifyEvent;
   property OnDblClick: TNotifyEvent;
   property OnDragOver: TDragOverEvent;
   property OnDragDrop: TDragDropEvent;
   property OnEditDblClick: TEditDblClickEvent;
   property OnEditKeyPress: TKeyPressEvent;
   property OnGetHintString: TGetHintStrEvent;
   property OnGetProperties: TGetPropertiesEvent;
   property OnGetSubProperties: TGetSubPropertiesEvent;
   property OnHelp: TNotifyEvent;
   property OnKeyDown: TKeyEvent;
   property OnKeyUp: TKeyEvent;
   property OnKeyPress: TKeyPressEvent;
   property OnListButtonClick: TNotifyEvent;
   property OnMouseDown: TMouseEvent;
   property OnMouseMove: TMouseMoveEvent;
   property OnMouseUp: TMouseEvent;
   property OnNCHitTest: TMouseMoveEvent;
   property OnQueryButtonClick: TNotifyEvent;
   property OnSelectionKeyDown: TKeyEvent;
   property OnSelectionKeyPress: TKeyPressEvent;
   property OnSelectItem: TNotifyEvent;
   property OnUpdateDirtyData: TNotifyEvent;
  end;
